import re

from sandbox.common.errors import TaskError
from sandbox.projects.common.vcs.arc import Arc


class ArcHelper:

    def __init__(self):
        pass

    def clone_repository(self, working_directory, branch=None, commit=None, extra_params=["--vfs-version", "2"]):
        if commit:
            return Arc().mount_path(
                path='',
                changeset=commit,
                mount_point=working_directory,
                fetch_all=False,
                extra_params=extra_params
            )
        if branch:
            branch = re.sub('^arcadia/', '', branch)
            arc = Arc()
            repo = arc.mount_path(
                path='',
                changeset=None,
                mount_point=working_directory,
                fetch_all=False,
                extra_params=extra_params
            )
            arc.fetch(
                mount_point=working_directory,
                branch=branch
            )
            arc.checkout(
                mount_point=working_directory,
                branch=branch
            )
            return repo
        raise TaskError("Either branch or commit should be given")

    def clone_with_task(self, task):
        """
        :param task: must have params from sandbox.projects.metrika.mobile.sdk.parameters.VcsParameters
        """
        task.logger.info("Using arc helper")
        repository = self.clone_repository(
            working_directory=task._work_dir(),
            branch=task.Parameters.branch,
            commit=task.Parameters.commit
        )
        task.logger.info("Arc log output {}".format(Arc().log(task._work_dir(), max_count=1)))
        return repository
