# coding=utf-8
import os

CERTIFICATE_PATH = 'certificate.pem'


class DistributionCertificateHelper:

    def __init__(self, shell_executor):
        self.shell_executor = shell_executor

    def import_certificate(self, certificate, password, work_dir):
        if certificate:
            with open(os.path.join(work_dir, CERTIFICATE_PATH), 'w') as cert_file:
                cert_file.write(certificate.data())

            unlock_keychain_command = ['security', 'unlock-keychain', '-p', password, 'login.keychain']
            self.shell_executor.execute_shell_and_check(unlock_keychain_command, work_dir)

            import_args = ['security', 'import', CERTIFICATE_PATH,
                           '-k', 'login.keychain',
                           '-T', '/usr/bin/codesign',
                           '-T', '/usr/bin/security']
            self.shell_executor.execute_shell_and_check(import_args, work_dir)

        set_key_partition_list_args = [
            'security', 'set-key-partition-list',
            '-S', 'apple-tool:,apple:,codesign:',
            '-s', '-k', password, 'login.keychain'
        ]

        self.shell_executor.execute_shell_and_check(set_key_partition_list_args, work_dir)
