# coding=utf-8
from contextlib import contextmanager

from sandbox.projects.metrika.mobile.sdk.helpers.ArcHelper import ArcHelper
from sandbox.projects.metrika.mobile.sdk.helpers.EmptyContext import EmptyContext

FRANKENSTEIN_BRANCH = 'trunk'


class EmulatorHelper:

    def __init__(self):
        pass

    def prepare_emulator(self, task):
        if task.Parameters.display_config:
            config = task.Parameters.display_config
            task.Utils.shell_executor.execute_shell_and_check(
                ["emulator-prepare.sh", config['density'], config['width'], config['height']])

    @contextmanager
    def logcat(self, task):
        """
        Parameter task has type sdk2.Task and should have the following
        1. Utils.shell_executor - ShellExecutor object
        2. log_path_custom - path to store output
        3. clean_up_timeout - method to calculate timeout
        :param task: sdk2.Task with the above requirements
        """
        try:
            task.Utils.shell_executor.execute_shell_and_check(["logcat-start.sh", str(task.log_path_custom())])
            yield None
        finally:
            task.Utils.shell_executor.execute_shell("logcat-stop.sh", timeout=task.clean_up_timeout)

    @contextmanager
    def xvfb(self, task):
        """
        Parameter task has type sdk2.Task and should have the following
        1. Utils.shell_executor - ShellExecutor object
        2. log_path_custom - path to store output
        3. clean_up_timeout - method to calculate timeout
        :param task: sdk2.Task with the above requirements
        """
        if task.Parameters.launch_xvfb:
            try:
                task.Utils.shell_executor.execute_shell_and_check(["Xvfb-start.sh", str(task.log_path_custom())])
                yield None
            finally:
                task.Utils.shell_executor.execute_shell("Xvfb-stop.sh", timeout=task.clean_up_timeout)
        else:
            yield None

    def boot_emulators(self, task):
        task.logger.info("Booting emulators using frankenstein")
        current_repo = EmptyContext()
        frankenstein_path = task._work_dir("mobile", "frankenstein", "sample")
        if task.Parameters.vcs_url != "arcadia":
            task.logger.info("Using arc since repo is not arcadia")
            current_repo = ArcHelper().clone_repository(
                working_directory=str(task.path("arc")),
                branch=FRANKENSTEIN_BRANCH
            )
            frankenstein_path = str(task.path("arc", "mobile", "frankenstein", "sample"))
        with current_repo:
            task.Utils.gradle_executor.execute_gradle_with_error(
                path=frankenstein_path,
                tasks=[task.Parameters.gradle_log_level, "--stacktrace", "bootAndroidEmulators"],
                gradle_properties=task._get_gradle_properties(),
                timeout=task.execute_shell_timeout,
                environment=task.env
            )
