# coding=utf-8
from sandbox.common.errors import TaskError
from sandbox.common.types.resource import State
from sandbox.projects.sandbox.resources import LXC_CONTAINER


class GradleContainerFinder:

    def __init__(self):
        pass

    def get_container(self, container_version="stable"):
        container = LXC_CONTAINER.find(state=State.READY, attrs={
            "android_gradle_runner": True,
            "version": container_version,
        }).first()

        if not container:
            raise TaskError("Gradle container with version {} not found".format(container_version))

        return container
