import six

from sandbox.common.errors import TaskError
from sandbox.common.errors import TaskFailure
from sandbox.projects.metrika.mobile.sdk.helpers.ShellExecutor import ShellExecutor


class GradleExecutor:

    def __init__(self):
        self.shell_executor = ShellExecutor()

    def execute_gradle_with_failure(self,
                                    path=None,
                                    tasks=None,
                                    gradle_properties=None,
                                    system_properties=None,
                                    timeout=None,
                                    build_file=None,
                                    environment=None):
        exitcode = self.execute_gradle(path=path, tasks=tasks, gradle_properties=gradle_properties,
                                       system_properties=system_properties, timeout=timeout, build_file=build_file,
                                       environment=environment)
        if exitcode:
            raise TaskFailure(
                "Command\n{!r}\nFAILED. Exit code: {!r}".format(tasks, exitcode))

    def execute_gradle_with_error(self,
                                  path=None,
                                  tasks=None,
                                  gradle_properties=None,
                                  system_properties=None,
                                  timeout=None,
                                  build_file=None,
                                  environment=None):
        exitcode = self.execute_gradle(path=path, tasks=tasks, gradle_properties=gradle_properties,
                                       system_properties=system_properties, timeout=timeout, build_file=build_file,
                                       environment=environment)
        if exitcode:
            raise TaskError(
                "Command\n{!r}\nFAILED. Exit code: {!r}".format(tasks, exitcode))

    def execute_gradle(self,
                       path=None,
                       tasks=None,
                       gradle_properties=None,
                       system_properties=None,
                       timeout=None,
                       build_file=None,
                       environment=None):
        args = ["./gradlew"]
        if build_file:
            args += ["--build-file={0}".format(build_file)]
        if system_properties:
            args += ["-D{0}={1}".format(k, v) for (k, v) in system_properties.iteritems()]
        if gradle_properties:
            args += ["-P{0}={1}".format(k, v) for (k, v) in gradle_properties.iteritems()]
        if isinstance(tasks, six.string_types):
            args += [tasks]
        else:
            args += list(tasks)
        return self.shell_executor.execute_shell(args, path, env=environment, timeout=timeout)
