from sandbox.projects.metrika.mobile.sdk.helpers.LinuxIosHelper import LinuxIosHelper
from sandbox.projects.metrika.mobile.sdk.helpers.MacIosHelper import MacIosHelper


class IosHelper:

    def __init__(self):
        self.linux_ios_helper = LinuxIosHelper()
        self.mac_ios_helper = MacIosHelper()

    def on_save(self, task):
        """
        :param task: task with TestParameters parameters
        """
        if task.Parameters.get_config_target:
            self.linux_ios_helper.on_save(task)
        else:
            self.mac_ios_helper.on_save(task)

    def on_prepare(self, task):
        """
        :param task: task with TestParameters parameters
        """
        if task.Parameters.get_config_target:
            self.linux_ios_helper.on_prepare(task)
        else:
            self.mac_ios_helper.on_prepare(task)

    def get_xcode_path(self, task):
        """
        :param task: task with TestParameters parameters
        """
        if task.Parameters.get_config_target:
            return self.linux_ios_helper.get_xcode_path(task)
        else:
            return self.mac_ios_helper.get_xcode_path(task)

    def prepare_env(self, task, env):
        """
        :param task: task with TestParameters parameters
        :param env: current environment
        """
        if task.Parameters.get_config_target:
            self.linux_ios_helper.prepare_env(task, env)
        else:
            self.mac_ios_helper.prepare_env(task, env)
