import sandbox.common.types.misc as ctm

from sandbox.common.types.client import Tag
from sandbox.common.types.misc import DnsType
from sandbox.projects.metrika.mobile.sdk.helpers.AndroidContainerFinder import AndroidContainerFinder
from sandbox.projects.metrika.mobile.sdk.helpers.ShellExecutor import ShellExecutor


class LinuxIosHelper:

    def __init__(self):
        pass

    def on_save(self, task):
        """
        :param task: task with IosCommonParameters parameters
        """
        task.Requirements.client_tags = Tag.GENERIC
        task.Requirements.dns = DnsType.DNS64
        task.Requirements.disk_space = 32768
        task.Requirements.cores = 4
        task.Requirements.ramdrive = ctm.RamDrive(ctm.RamDriveType.TMPFS, 2048, None)
        task.Requirements.ram = 16384
        task.Requirements.container_resource = AndroidContainerFinder().get_build_container("stable").id

    def on_prepare(self, task):
        pass

    def get_xcode_path(self, task):
        """
        :param task: ignore
        """
        return None

    def prepare_env(self, task, env):
        """
        :param task: ignore
        :param env: current environment
        """
        if 'JAVA_HOME' not in env:
            env['JAVA_HOME'] = '/usr/local/java8'
        ShellExecutor.prepare_java_options(env)
