# coding=utf-8
import os
import distutils
import pathlib2

PROVISIONING_REPO_URL = 'ssh://git@bitbucket.browser.yandex-team.ru/mt/mobile-ios-provisioning-profiles.git'
PROVISIONING_DIR = 'provisioning'
PROVISIONING_FILES_PATH = str(pathlib2.Path.home().joinpath('Library/MobileDevice/Provisioning Profiles'))


class ProvisioningHelper:

    def __init__(self, git_helper):
        self.git_helper = git_helper
        self.files_to_delete = []

    def clone_provisioning(self, root_dir, ssh_key):
        self.git_helper.clone_repository(
            working_directory=os.path.join(root_dir, PROVISIONING_DIR),
            vcs_url=PROVISIONING_REPO_URL,
            branch='',
            ssh_key=ssh_key
        )

    def prepare_provisioning(self, logger, root_dir):
        """
        download and copy provisioning files
        """
        adhoc_provisioning_path = os.path.join(root_dir, PROVISIONING_DIR, 'AdHoc')
        appstore_provisioning_path = os.path.join(root_dir, PROVISIONING_DIR, 'AppStore')

        if not os.path.exists(PROVISIONING_FILES_PATH):
            os.makedirs(PROVISIONING_FILES_PATH)

        self.files_to_delete = os.listdir(adhoc_provisioning_path) + os.listdir(appstore_provisioning_path)
        logger.info("Copy from {0} to {1}".format(adhoc_provisioning_path, PROVISIONING_FILES_PATH))
        distutils.dir_util.copy_tree(adhoc_provisioning_path, PROVISIONING_FILES_PATH)

        logger.info("Copy from {0} to {1}".format(appstore_provisioning_path, PROVISIONING_FILES_PATH))
        distutils.dir_util.copy_tree(appstore_provisioning_path, PROVISIONING_FILES_PATH)

    def remove_files(self):
        for filename in self.files_to_delete:
            os.remove(os.path.join(PROVISIONING_FILES_PATH, filename))
