# coding=utf-8
import logging
import os
import pathlib2
import shutil

from sandbox import sdk2
from sandbox.common import fs
from sandbox.projects.metrika.mobile.sdk.helpers.TarResourceHelper import TarResourceHelper
from sandbox.sdk2 import paths


class ReportsHelper:

    def __init__(self):
        self.tar_resource_helper = TarResourceHelper()

    def copytree_multi(self, src, dst, file_postfix):
        names = os.listdir(src)
        if not os.path.isdir(dst):
            os.makedirs(dst)
        for name in names:
            srcname = os.path.join(src, name)
            dstname = os.path.join(dst, name)
            if os.path.isdir(srcname):
                self.copytree_multi(srcname, dstname, file_postfix)
            else:
                if os.path.exists(dstname):
                    dst_path = pathlib2.Path(dstname)
                    dstname = "{}/{}_{}{}".format(dst_path.parent, dst_path.stem, file_postfix, dst_path.suffix)
                shutil.copy2(srcname, dstname)
        shutil.copystat(src, dst)

    def copy_reports_and_merge(self, tasks, dst, temp_dir):
        """
        :param tasks: dict from task name to task id
        :param dst: destination
        :param temp_dir: temporary dir to extract tar
        """
        for test_task_caption, test_task_id in tasks:
            if test_task_caption and test_task_id:
                try:
                    logging.info("Copying reports from task {} with id {}".format(test_task_caption, test_task_id))
                    task = sdk2.Task[test_task_id]
                    temp_resource = sdk2.Resource[task.Context.artifacts_resource_id]
                    self.tar_resource_helper.extract_input_resource(temp_resource, temp_dir, task)
                    reports_dir = str(pathlib2.Path(temp_dir).joinpath("reports").as_posix())
                    if os.path.exists(reports_dir):
                        self.copytree_multi(reports_dir, dst, test_task_caption)
                        shutil.rmtree(reports_dir, ignore_errors=True)
                except Exception as e:
                    logging.info("Error while copying : {}".format(e))

    def copy_reports(self, task):
        for test_task_caption, test_task_id in task.Context.test_task_ids.items():
            if test_task_caption and test_task_id:
                try:
                    logging.info("Copying reports from task {} with id {}".format(test_task_caption, test_task_id))
                    temp_resource = sdk2.Resource[sdk2.Task[test_task_id].Context.artifacts_resource_id]
                    self.tar_resource_helper.extract_input_resource(temp_resource, task.path(), task)
                    if os.path.exists("reports"):
                        fs.copy_dir("reports", task._work_dir(test_task_caption))
                        shutil.rmtree("reports", ignore_errors=True)
                    # experiment for https://st.yandex-team.ru/FRANKENSTEIN-997
                    add_write_permissions = getattr(task.Parameters, 'add_write_permissions', True)
                    logging.info("Need add_write_permissions for path {}? {}".format(
                        task._work_dir(), add_write_permissions))
                    if add_write_permissions:
                        paths.add_write_permissions_for_path(task._work_dir())
                except Exception as e:
                    logging.info("Error while copying : {}".format(e))

    def copy_log_dir(self, task):
        if task.Parameters.pass_logs_to_teamcity:
            for test_task_caption, test_task_id in task.Context.test_task_ids.items():
                if test_task_caption and test_task_id:
                    logging.info("Copying logs from task {} with id {}".format(test_task_caption, test_task_id))
                    log_resources = sdk2.Resource["TASK_LOGS"].find(
                        task=sdk2.Task[test_task_id]
                    ).limit(10)
                    logging.info([resource.id for resource in log_resources])
                    last_log_resource = log_resources.first()
                    if last_log_resource is not None:
                        fs.copy_dir(str(sdk2.ResourceData(last_log_resource).path.as_posix()),
                                    task._work_dir(test_task_caption, "sandbox_logs"))
                        # experiment for https://st.yandex-team.ru/FRANKENSTEIN-997
                        add_write_permissions = getattr(task.Parameters, 'add_write_permissions', True)
                        logging.info("Need add_write_permissions for path {}? {}".format(
                            task._work_dir(), add_write_permissions))
                        if add_write_permissions:
                            paths.add_write_permissions_for_path(task._work_dir())
        else:
            logging.info("Logs were not passed to teamcity since pass_logs_to_teamcity is False or None")

    def copy_aggregated_report(self, task):
        task_id = task.Context.report_task_id
        if task_id:
            try:
                logging.info("Copying reports from task {} with id {}".format("Aggregated report", task_id))
                temp_resource = sdk2.Resource[sdk2.Task[task_id].Context.artifacts_resource_id]
                self.tar_resource_helper.extract_input_resource(temp_resource, task.path(), task)
                if os.path.exists("aggregated_allure_report"):
                    fs.copy_dir("aggregated_allure_report", task._work_dir("aggregated"))
                # experiment for https://st.yandex-team.ru/FRANKENSTEIN-997
                add_write_permissions = getattr(task.Parameters, 'add_write_permissions', True)
                logging.info("Need add_write_permissions for path {}? {}".format(
                    task._work_dir(), add_write_permissions))
                if add_write_permissions:
                    paths.add_write_permissions_for_path(task._work_dir())
            except Exception as e:
                logging.info("Error while copying : {}".format(e))
