# coding=utf-8
from sandbox import sdk2


class AggregatedReportParameters(sdk2.Task.Parameters):
    """
    Параметры для создания отчета на основе всех тестов
    """
    with sdk2.parameters.Group("Aggregated report parameters") as aggregated_report_parameters:
        aggregated_report_task = sdk2.parameters.String("Aggregated report task",
                                                        description="gradle задача по созданию отчета")
        tasks_reports_dir_param_name = sdk2.parameters.String(
            "Параметр с каталогом с отчетами из прогонов тестов",
            description="Параметр, куда будет передан путь, куда положили результаты прогона тестов."
                        "Для каждого прогона тестов берется папка 'reports' (output_dir_param_name) "
                        "и кладется в эту папку с именем равным названию прогона.",
            default="gradle.input.dir")
        aggregated_reports_dir_param_name = sdk2.parameters.String(
            "Параметр с каталогом с агрегированным отчетом",
            description="Параметр, куда будет передан путь, который будет сохранен в выходной ресурс.",
            default="gradle.output.dir")
        aggregated_reports = sdk2.parameters.Dict(
            "Публикуемые аггрегированные отчёты",
            default={"Aggregated Report": "aggregated_allure_report/index.html"},
            description="Перечень отчётов, ключ - название отчёта, значение - "
                        "относительный путь к html-файлу отчёта. Путь отсчитывается "
                        "относительно каталога, переданного в предыдущем параметре.")

    @staticmethod
    def get(task):
        return {
            AggregatedReportParameters.aggregated_report_task.name: task.Parameters.aggregated_report_task,
            AggregatedReportParameters.tasks_reports_dir_param_name.name: task.Parameters.tasks_reports_dir_param_name,
            AggregatedReportParameters.aggregated_reports_dir_param_name.name: task.Parameters.aggregated_reports_dir_param_name,
            AggregatedReportParameters.aggregated_reports.name: task.Parameters.aggregated_reports,
        }
