# coding=utf-8
from sandbox import sdk2


class BuildAgentParameters(sdk2.Task.Parameters):
    """
    Параметры, для хранения информации о собранных агентах
    """
    with sdk2.parameters.Group("Build agent parameters") as build_agent_parameters_group:
        resource_path = sdk2.parameters.String("Agent path",
                                               description="Путь, по которому надо взять агенты и подложить их в тесты. "
                                                           "Если указано и не указан Agent resource, то для сборки агентов вызывается отдельная задача. "
                                                           "Если указано и указан Agent resource, то он используется как ресурс с агентами. "
                                                           "Иначе сборка агентов вызывается перед исполнением тестов в каждой задаче.")
        tests_resource = sdk2.parameters.Resource("Agent resource",
                                                  description="Ресурс с собранным агентом. Будет положен по пути 'Agent path'")

    @staticmethod
    def get(task):
        return {
            BuildAgentParameters.resource_path.name: task.Parameters.resource_path,
            BuildAgentParameters.tests_resource.name: task.Parameters.tests_resource,
        }
