# coding=utf-8
from sandbox import sdk2


class GradleParameters(sdk2.Task.Parameters):
    """
    Параметры для работы с Gradle
    """
    with sdk2.parameters.Group("Gradle") as gradle_group:
        gradle_parameters = sdk2.parameters.Dict("Gradle-параметры",
                                                 description="Параметры, которые передаются в gradle через -P")
        secret_gradle_parameters = sdk2.parameters.Dict("Секретные gradle-параметры",
                                                        description="Параметры, которые будут получены из vault "
                                                                    "и переданы в gradle через -P, "
                                                                    "значения необходимо задавать в формате owner:name")
        system_gradle_parameters = sdk2.parameters.Dict("Системные gradle-параметры",
                                                        description="Параметры, которые передаются в gradle через -D")
        gradle_base_dir = sdk2.parameters.String("Корневой каталог gradle",
                                                 description="Каталог относительно репозитория, в котором лежит gradlew")
        build_file = sdk2.parameters.String("Путь к build.gradle",
                                            description="Путь к build.gradle относительно корневого каталога gradle. "
                                                        "Передается через опцию -b")
        with sdk2.parameters.RadioGroup('Gradle log level') as gradle_log_level:
            gradle_log_level.values[''] = gradle_log_level.Value(value='No logging option')
            gradle_log_level.values['--quiet'] = gradle_log_level.Value(value='--quiet')
            gradle_log_level.values['--warn'] = gradle_log_level.Value(value='--warn')
            gradle_log_level.values['--info'] = gradle_log_level.Value(value='--info', default=True)
            gradle_log_level.values['--debug'] = gradle_log_level.Value(value='--debug')
        env = sdk2.parameters.Dict("Параметры окружения", default={})

    @staticmethod
    def get(task):
        return {
            GradleParameters.gradle_parameters.name: task.Parameters.gradle_parameters,
            GradleParameters.secret_gradle_parameters.name: task.Parameters.secret_gradle_parameters,
            GradleParameters.system_gradle_parameters.name: task.Parameters.system_gradle_parameters,
            GradleParameters.gradle_base_dir.name: task.Parameters.gradle_base_dir,
            GradleParameters.build_file.name: task.Parameters.build_file,
            GradleParameters.gradle_log_level.name: task.Parameters.gradle_log_level,
            GradleParameters.env.name: task.Parameters.env,
        }

    @staticmethod
    def prepare_env(task, env):
        env.update(task.Parameters.env)
