# coding=utf-8
from sandbox import sdk2


class OptimizationParameters(sdk2.Task.Parameters):
    """
    Параметры для оптимизации задачи в плане использования ресурсов
    """

    with sdk2.parameters.Group("Optimization parameters") as optimization_group:
        with sdk2.parameters.RadioGroup("Multislot",
                                        description="Создает соответствующее ограничение на количество ядер. "
                                                    "Снизится потребление квоты. "
                                                    "Если стоит 'No multislot', то ограничений нет") as multislot_type:
            multislot_type.values['2'] = multislot_type.Value(value="cores=2, ram=7Gb", default=True)
            multislot_type.values['8'] = multislot_type.Value(value="cores=8, ram=31Gb")
            multislot_type.values['16'] = multislot_type.Value(value="cores=16, ram=63Gb")
            multislot_type.values['none'] = multislot_type.Value(value="No multislot (ram=96Gb)")
        use_tmpfs = sdk2.parameters.Bool("Use tmpfs",
                                         description="Монтировать и использовать RamDrive",
                                         default=False)
        use_ssd = sdk2.parameters.Bool("Use SSD only",
                                       description="Исполнять только на агентах с SSD",
                                       default=False)

    @staticmethod
    def get(task):
        return {
            OptimizationParameters.multislot_type.name: task.Parameters.multislot_type,
            OptimizationParameters.use_tmpfs.name: task.Parameters.use_tmpfs,
            OptimizationParameters.use_ssd.name: task.Parameters.use_ssd,
        }
