# coding=utf-8
from sandbox import sdk2


class ResourceParameters(sdk2.Task.Parameters):
    """
    Параметры для работы с входными и выходными ресурсами задачи.
    """
    with sdk2.parameters.Group("Resource parameters") as resource_parameters:
        input_resource_path_param_name = sdk2.parameters.String(
            "Input resource gradle parameter",
            description="Параметр, куда будет передан путь, куда положили входные ресурсы."
                        "Если задан 'Input resource directory', то параметр не передается.",
            default="gradle.input.dir")
        input_resource_path = sdk2.parameters.String("Input resource directory",
                                                     description="Путь, куда положить ресурс")
        input_resource = sdk2.parameters.Resource("Input resource",
                                                  description="Дополнительный ресурс для сборки")
        output_resource_path_param_name = sdk2.parameters.String(
            "Output resource gradle parameter",
            description="Параметр, куда будет передан путь, который будет сохранен в выходной ресурс."
                        "Если задан 'Output resource directory', то параметр не передается.",
            default="gradle.output.dir")
        output_resource_path = sdk2.parameters.String("Output resource directory",
                                                      description="Путь, который будет сохранен в ресурс")
        output_resource_ttl = sdk2.parameters.Integer("Output resource ttl",
                                                      description="Время жизни выходного ресурса")
        output_resource_reports = sdk2.parameters.Dict(
            "Ссылки на публикуемые ресурсы",
            default={},
            description="Перечень отчётов, ключ - название отчёта, значение - "
                        "относительный путь к html-файлу отчёта. Путь отсчитывается "
                        "относительно каталога, сохраненного в ресурс.")
        with sdk2.parameters.Output:
            output_resource = sdk2.parameters.Resource("Output resource",
                                                       description="Ресурс, содержащий указанную папку/файл")

    @staticmethod
    def get(task):
        return {
            ResourceParameters.input_resource_path_param_name.name: task.Parameters.input_resource_path_param_name,
            ResourceParameters.input_resource_path.name: task.Parameters.input_resource_path,
            ResourceParameters.input_resource.name: task.Parameters.input_resource,
            ResourceParameters.output_resource_path_param_name.name: task.Parameters.output_resource_path_param_name,
            ResourceParameters.output_resource_path.name: task.Parameters.output_resource_path,
            ResourceParameters.output_resource_ttl.name: task.Parameters.output_resource_ttl,
            ResourceParameters.output_resource_reports.name: task.Parameters.output_resource_reports,
            ResourceParameters.output_resource.name: task.Parameters.output_resource,
        }
