# coding=utf-8
from sandbox import sdk2


class ResourcePublishParameters(sdk2.Task.Parameters):
    """
    Параметры для сохранения папки в ресурс
    """
    with sdk2.parameters.Group("Resource for tests") as test_resources:
        resource_path = sdk2.parameters.String("Resource directory",
                                               description='Путь, который будет сохранен в ресурс')
        with sdk2.parameters.Output:
            composed_resource = sdk2.parameters.Resource('Resource',
                                                         description='Ресурс, содержащий указанную папку/файл')

    @staticmethod
    def get(task):
        return {
            ResourcePublishParameters.resource_path.name: task.Parameters.resource_path,
            ResourcePublishParameters.composed_resource.name: task.Parameters.composed_resource,
        }
