# coding=utf-8
from sandbox import sdk2


class SplitParameters(sdk2.Task.Parameters):
    """
    Параметры разбиения тестов
    """
    with sdk2.parameters.Group("Split parameters") as split_parameters_group:
        additional_params_path = sdk2.parameters.String("Additional params path",
                                                        description="Пусть, по которому будет лежать файл с дополнительной информацией."
                                                                    "Относительно working dir.",
                                                        required=False, default="")
        additional_params = sdk2.parameters.JSON("Additional params",
                                                 description="Дополнительные параметры для прогона",
                                                 required=False, default={})

    @staticmethod
    def get(task):
        return {
            SplitParameters.additional_params_path.name: task.Parameters.additional_params_path,
            SplitParameters.additional_params.name: task.Parameters.additional_params,
        }
