# coding=utf-8
from sandbox import sdk2


class TeamcityParameters(sdk2.Task.Parameters):
    """
    Параметры для работы с Teamcity
    """
    with sdk2.parameters.Group("Teamcity") as teamcity_group:
        teamcity_artifact_name = sdk2.parameters.String("Artifact name on teamcity",
                                                        description="Command for teamcity upload will be 'wd => {teamcity_artifact_name}'",
                                                        default="report.zip")
        teamcity_artifact_paths = sdk2.parameters.Dict("Artifact paths",
                                                       description="Пути к файлам или папками, которые необходимо "
                                                                   "опубликовать в качестве артифактов сборки на Team City")
        pass_reports_to_teamcity = sdk2.parameters.Bool("Pass all reports to teamcity",
                                                        default=False)
        pass_logs_to_teamcity = sdk2.parameters.Bool("Pass log_ reports to teamcity",
                                                     default=False)

    @staticmethod
    def get(task):
        return {
            TeamcityParameters.teamcity_artifact_name.name: task.Parameters.teamcity_artifact_name,
            TeamcityParameters.teamcity_artifact_paths.name: task.Parameters.teamcity_artifact_paths,
            TeamcityParameters.pass_reports_to_teamcity.name: task.Parameters.pass_reports_to_teamcity,
            TeamcityParameters.pass_logs_to_teamcity.name: task.Parameters.pass_logs_to_teamcity,
        }
