# coding=utf-8
from sandbox import sdk2


class VcsParameters(sdk2.Task.Parameters):
    """
    Параметры для настройки работы с VCS
    """
    with sdk2.parameters.Group("VCS") as vcs_group:
        vcs_url = sdk2.parameters.String("Git репозиторий",
                                         description="Адрес git репозитария, где лежит проект с автотестами",
                                         required=True)
        branch = sdk2.parameters.String("Ветка или hash коммита",
                                        description="Ветка или hash коммита git репозитория, на которой исполнять тесты",
                                        required=True,
                                        default="dev")
        commit = sdk2.parameters.String("Хэш коммита",
                                        description="Не используется пока. Заполняется автоматически teamcity.")
        use_latest_revision = sdk2.parameters.Bool("Use latest revision",
                                                   description="Обновлять субмодули с опцией --remote",
                                                   default=False)
        need_git_lfs = sdk2.parameters.Bool("Git lfs", description="Использовать git lfs")
        ssh_key = sdk2.parameters.Vault("SSH-ключ",
                                        description="SSH-ключ, который берётся из vault и будет использоваться "
                                                    "для клонирования репозитория в случае неанонимного доступа, "
                                                    "значение необходимо задавать в формате owner:name",
                                        default="")
        ssh_key_yav = sdk2.parameters.YavSecret("SSH-ключ yav(experiment)",
                                                description="SSH-ключ, который берётся из yav и будет использоваться "
                                                            "для клонирования репозитория в случае неанонимного доступа.")
        use_new_git_helper = sdk2.parameters.Bool("Use new git helper",
                                                  description="May be more quick, but do not support submodules",
                                                  default=False)

    @staticmethod
    def get(task):
        return {
            VcsParameters.vcs_url.name: task.Parameters.vcs_url,
            VcsParameters.branch.name: task.Parameters.branch,
            VcsParameters.commit.name: task.Parameters.commit,
            VcsParameters.use_latest_revision.name: task.Parameters.use_latest_revision,
            VcsParameters.need_git_lfs.name: task.Parameters.need_git_lfs,
            VcsParameters.ssh_key.name: task.Parameters.ssh_key,
            VcsParameters.ssh_key_yav.name: task.Parameters.ssh_key_yav,
            VcsParameters.use_new_git_helper.name: task.Parameters.use_new_git_helper,
        }
