import tempfile

from sandbox import sdk2
from sandbox.common.types.misc import DnsType


class RunScriptBase(sdk2.Task):
    """
    Base class for tasks which runs scripts
    """

    class Requirements(sdk2.Task.Requirements):
        dns = DnsType.DNS64

    class Parameters(sdk2.Task.Parameters):
        script = sdk2.parameters.String("Script to execute", required=True, multiline=True)

    def on_execute(self):
        with tempfile.NamedTemporaryFile() as script_file:
            script_file.write(self.Parameters.script)
            script_file.flush()
            with sdk2.helpers.ProcessLog(self, logger="script") as log:
                sdk2.helpers.subprocess.check_call(['/bin/bash', script_file.name],
                                                   stdout=log.stdout,
                                                   stderr=sdk2.helpers.process.subprocess.STDOUT)
