#!/bin/bash
set -e

RUBY_VERSION="{}"
U3D_VERSION="{}"

# install xar
# http://mackyle.github.io/xar/
# https://www.oueta.com/linux/extract-pkg-and-mpkg-files-with-xar-on-linux/
apt-get install -y wget build-essential libxml2-dev libxml2-utils libssl-dev zlib1g-dev
wget https://github.com/downloads/mackyle/xar/xar-1.6.1.tar.gz
tar -zxvf xar-1.6.1.tar.gz
cd xar-1.6.1
./configure
make
make install

# install u3d
# https://github.com/DragonBox/u3d
# https://github.com/rvm/ubuntu_rvm#install
apt-get install -y software-properties-common
add-apt-repository -y -u ppa:rael-gc/rvm
apt-get install -y rvm
source /etc/profile.d/rvm.sh
rvm install ruby "$RUBY_VERSION"
if [[ -n "$U3D_VERSION" ]]; then
    gem install u3d --version "$U3D_VERSION"
else
    gem install u3d
fi

# test
echo 'environment'
env
echo 'xar version'
xar --version
echo 'u3d version'
u3d --version
