import os

from sandbox import sdk2
from sandbox.sdk2.environments import TarballToolkitBase


class Unity(sdk2.Resource):
    """
        Tarball with installed Unity
    """
    version = sdk2.Attributes.String("version", required=True)
    platform = sdk2.Attributes.String("platform", required=True)
    packages = sdk2.Attributes.String("packages", required=True)
    any_arch = False
    auto_backup = True
    pack_tar = 2
    ttl = 365


class UnityEnvironment(TarballToolkitBase):
    """
        Unity environment
    """
    resource_type = Unity
    name = "unity"

    def __init__(self, version, platform="darwin"):
        super(UnityEnvironment, self).__init__(version, platform)

    def prepare(self):
        env_dir = super(UnityEnvironment, self).prepare()
        if self.platform == "darwin":
            self.update_os_env("UNITY_DIR_PATH", os.path.join(env_dir))
            self.update_os_env("UNITY_PATH", os.path.join(env_dir, "Unity.app"))
            self.update_os_env("UNITY_BIN_PATH", os.path.join(env_dir, "Unity.app/Contents/MacOS/Unity"))
        elif self.platform == "linux":
            self.update_os_env("UNITY_DIR_PATH", os.path.join(env_dir, "unity"))
            self.update_os_env("UNITY_PATH", os.path.join(env_dir, "unity/Editor"))
            self.update_os_env("UNITY_BIN_PATH", os.path.join(env_dir, "unity/Editor/Unity"))
        self.check_environment()
        return env_dir
