#!/bin/bash
set -e

CUR_DIR="$(pwd)"
DOWNLOAD_DIR="unity_download"

VERSION="$1"
PLATFORM="$2"
PACKAGES="$3"
DEST="$4"

function unpack_tar() {
    tar xf "$1"
}

function unpack_pkg() {
    local file="$1"
    local dst="$(basename "$file").extracted"
    local cur_dir="$(pwd)"

    mkdir -p "$dst" && cd "$dst" || exit 2
    xar -xf "$file"
    cd ./*.pkg.tmp || exit 2
    local payload_file="$(pwd)/Payload"
    echo "Found Payload '$payload_file'"
    local install_path="$(xmllint --xpath "string(/pkg-info/@install-location)" PackageInfo)"
    install_path="${install_path#/Applications}"
    if [[ "$PLATFORM" == "linux" ]]; then
        install_path="/Editor/Data${install_path#/Unity}"
    fi
    install_path=".$install_path"
    echo "Found install path '$install_path'"

    cd "$cur_dir" || exit 2
    mkdir -p "$install_path" && cd "$install_path" || exit 2
    gunzip -dc "$payload_file" | cpio -i

    cd "$cur_dir" || exit 2
    rm -rf "$dst"
}

U3D_DOWNLOAD_PATH="$DOWNLOAD_DIR" u3d install "$VERSION" --no-install -o "$PLATFORM" -p "$PACKAGES" --trace

rm -rf "$DEST"
if [[ "$PLATFORM" != "mac" ]]; then
    mkdir -p "$DEST" && cd "$DEST" || exit 2
fi
for file in "$CUR_DIR/$DOWNLOAD_DIR/$VERSION"/*; do
    echo "Unpack archive ${file}"
    if [[ "$file" =~ \.tar\.xz$ ]]; then
        unpack_tar "$file"
    elif [[ "$file" =~ \.pkg$ ]]; then
        unpack_pkg "$file"
    else
        echo "Unknown format file '${file}'"
        exit 1
    fi
done
if [[ "$PLATFORM" == "mac" ]]; then
    mv Unity "$DEST"
fi
