from sandbox import sdk2
from sandbox.common.types.client import Tag
from sandbox.projects.metrika.mobile.sdk.fastlane_runner import FastlaneRunner
from sandbox.projects.metrika.mobile.unity.unity_environment import UnityEnvironment


class UnityRunner(FastlaneRunner):
    """
    Build Unity3d project
    """

    class Parameters(FastlaneRunner.Parameters):
        with sdk2.parameters.Group("Unity parameters") as unity_group:
            unity_version = sdk2.parameters.String("Unity version", required=True)

    def on_save(self):
        super(UnityRunner, self).on_save()
        self.Requirements.client_tags = self.Requirements.client_tags & Tag.USER_UNITY

    def on_prepare(self):
        super(UnityRunner, self).on_prepare()
        with sdk2.helpers.ProgressMeter("Prepare Unity environment"):
            UnityEnvironment(self.Parameters.unity_version).prepare()
