# coding=utf-8

import requests


class MdbAuth(requests.auth.AuthBase):
    def __init__(self, user, password):
        self.user = user
        self.password = password

    def __call__(self, r):
        r.headers['X-ClickHouse-User'] = self.user
        r.headers['X-ClickHouse-Key'] = self.password
        return r


class OAuth(requests.auth.AuthBase):
    def __init__(self, token):
        self.token = token

    def __call__(self, r):
        r.headers['Authorization'] = "OAuth {}".format(self.token)
        return r
