import logging

from sandbox import sdk2
from sandbox.projects.metrika.utils import settings


def get_bishop_client():
    from metrika.pylib.bishop import Bishop
    bishop_client = Bishop(token=sdk2.Vault.data(settings.owner, settings.bishop_token))
    bishop_client._verify = False
    return bishop_client


def is_bishop_environment_exists(bishop_client, environment):
    from metrika.pylib.bishop import BishopError
    try:
        bishop_client.environment.get(environment)
    except BishopError as error:
        if error.status_code == 404:
            logging.info("Environment '{}' doesn't exist in Bishop.".format(environment))
            return False
        else:
            raise error
    else:
        return True


def delete_bishop_environment(bishop_client, environment):
    from metrika.pylib.bishop import BishopError

    if not is_bishop_environment_exists(bishop_client, environment):
        return

    try:
        programs = {config["program"] for config in bishop_client.config.list(environment=environment)["data"]}
    except BishopError as e:
        if e.status_code != 404:
            raise
    else:
        bishop_client.config.delete(environment=environment)
        logging.debug("Deleted configs for environment '{}'".format(environment))
        for program in programs:
            try:
                bishop_client.program.detach_environment(program, environment)
            except BishopError as e:
                if e.status_code != 400:
                    raise
        logging.debug("Detached programs for environment '{}'".format(environment))

    bishop_client.environment.delete(environment)
    logging.debug("Deleted environment '{}'".format(environment))


def create_bishop_environment(bishop_client, parent, environment_name, environment_variables, program):
    environment = "{}.{}".format(parent, environment_name)

    if is_bishop_environment_exists(bishop_client, environment):
        delete_bishop_environment(bishop_client, environment)

    bishop_client.environment.create(environment_name, parent, auto_activation=True)

    for key, value in environment_variables.items():
        bishop_client.variable.create(environment=environment, variable_type="string", name=key, value=value)

    bishop_client.request("{}/{}/environments/{}".format(bishop_client.program.path, program, environment), method="POST", data={"auto_activation": True})

    return environment
