import logging

from sandbox.common import errors


def bstr_push(**config):
    import library.python.bstr.push as bstr
    import metrika.pylib.bstr.config as bstr_config

    config = bstr_config.BstrConfig(**config)
    bstr_args = config.get_args()

    logging.debug("Start bstr push")
    try:
        bstr.main(bstr_args, init_logger=False)
    except Exception as e:
        if e.message == 'timeout':
            raise errors.TaskFailure("Can't push file to %s hosts in %s seconds." % (config.quorum, config.timeout))
        raise
