# coding=utf-8
import logging
from sandbox.sdk2.path import Path
from sandbox.projects.common.vcs import arc
from sandbox.projects.metrika.utils import vcs, settings


def edit_files(task, arcadia_url, files, message, push_force=True):
    """
    Редактирует указанные файлы,
    :param task: - исполняемая Sandbox-задача
    :param arcadia_url: url Аркадии для монтирования
    :param files: словарь - ключ - относительный путь относительно переданного url'а Аркадии
    :param message: - commit message
    :param push_force: делать ли push с force - полезно, в случае перезапусков задачи, т.к. имя ветки - производное от идентификатора задачи
    :return: branch
    """
    arc_client = arc.Arc()
    branch = "users/{}/{}".format(settings.login, task.id)
    logging.info("Branch: %s", branch)
    with vcs.mount_arc(arcadia_url) as arcadia_mount_point:
        arc_client.checkout(arcadia_mount_point, branch=branch, create_branch=True)
        for rel_path, content in files.items():
            (Path(arcadia_mount_point) / rel_path).write_text(content, encoding='utf-8')
            arc_client.add(arcadia_mount_point, rel_path)
        response = arc_client.status(arcadia_mount_point, as_dict=True)
        logging.debug("%s", response)
        if response["status"]:
            arc_client.commit(arcadia_mount_point, message)
            arc_client.push(arcadia_mount_point, upstream=branch, force=push_force)
            return branch
        else:
            logging.info("No changes found")
            return None
