# coding=utf-8
from __future__ import unicode_literals


class Contextable(dict):
    __getattr__ = dict.__getitem__
    __setattr__ = dict.__setitem__

    # для создания таски
    __getstate__ = lambda self: self
    __setstate__ = lambda self, state: self.__init__(**state)
    __deepcopy__ = lambda self, m: self.__init__(**self)

    @classmethod
    def fill(cls, object):
        if object is None:
            return None
        elif isinstance(object, type):
            return object
        elif isinstance(object, dict):
            return cls(**object)
        else:
            raise ValueError('Object must be {} or dict, got {}'.format(cls.__name__, object.__class__.__name__))
