# coding=utf-8
import logging

# это версия MySQL в MaaS
# если случится ещё одно обновление, то нужно добавить сюда ещё константу
# и можно будет переключать таски по этапно.
VERSION_TAG = "8.0.25-15-8840598"


class MaasProvider:
    def __init__(self, bishop_token, dc=None):
        from metrika.pylib.config import get_yaml_config_from_bishop
        self._config = get_yaml_config_from_bishop("maas-provider", "metrika.sandbox.admin.production", token=bishop_token)
        logging.debug("MaaS Provider config:\n%s", self._config)
        self.dc = dc
        logging.debug("Default dc is %s", self.dc)

    @staticmethod
    def _get_maas_client(maas_host):
        from metrika.pylib.maas import MaaS
        logging.info("create MaaS client for host: %s", maas_host)
        return MaaS(maas_host, https=False)

    @property
    def datacenter(self):
        return self.dc or self._config.active_dc

    @property
    def maas_host(self):
        return self._config.maas[self.datacenter]

    @property
    def caas_host(self):
        return self._config.caas[self.datacenter]

    def get_maas_client(self):
        return MaasProvider._get_maas_client(self.maas_host)

    def get_maas_clients(self):
        return [MaasProvider._get_maas_client(host) for host in self._config.maas.values()]

    def get_caas_client(self):
        return MaasProvider._get_maas_client(self.caas_host)

    def get_caas_clients(self):
        return [MaasProvider._get_maas_client(host) for host in self._config.caas.values()]
