# coding=utf-8
from __future__ import unicode_literals

import logging

from sandbox import sdk2
from sandbox.common.patterns import singleton_property
from sandbox.projects.metrika.utils import settings
from sandbox.projects.metrika.utils.parameters import TrackerIssue


class AutoTicketMixin(object):
    @singleton_property
    def st_client(self):
        from startrek_client import Startrek
        return Startrek(token=sdk2.Vault.data(settings.owner, settings.tracker_token), useragent=settings.owner)

    def on_execute(self):
        """
        :param sdk2.Task self:
        """
        from startrek_client import exceptions

        for param in type(self).Parameters:
            if param.__name__ == TrackerIssue.__name__ and param.autolink:
                try:
                    key = getattr(self.Parameters, param.name)
                    if key:
                        self.st_client.issues[key].remotelinks.create('relates', self.id, 'ru.yandex.sandbox')
                except exceptions.Forbidden as e:
                    logging.exception(e)
                except exceptions.StartrekServerError as e:
                    if 'уже связаны' not in str(e):
                        raise
