# coding=utf-8
import logging

from sandbox import sdk2
from sandbox.common.types.resource import State
from sandbox.common.types.task import ReleaseStatus
from sandbox.projects.common import utils
from sandbox.projects.common.ya_deploy.release_integration import ReleaseToYaDeployTask2, stringify_resource_attributes
from sandbox.projects.metrika.utils import settings


class DynResourceMixin(ReleaseToYaDeployTask2, object):
    YP_TOKEN_YAV_SECRET_ID = settings.yav_uuid
    RESOURCE_COUNT = None  # количество релизнутых ресурсов одного типа
    MUST_RELEASE = True  # обязательно должны быть ресурсы для релиза

    @property
    def dyn_resources(self):
        return [r for r in sdk2.Resource.find(task=self).limit(0) if r.type.releasable]

    def get_yd_release_resources(self):
        resources = []
        for r in self.dyn_resources:
            resources.append({
                'resource_id': str(r.id),
                'type': r.type.name,
                'filename': r.path.name,
                'description': r.description,
                'skynet_id': r.skynet_id,
                'arch': r.arch or '',
                'file_md5': r.md5 or '',
                'releasers': r.releasers or [],
                'attributes': stringify_resource_attributes(dict(r))
            })
        logging.info('List of resources to release:\n{}'.format(resources))
        return resources

    def on_success(self, prev_status):
        """
        :param sdk2.Task self:
        """

        resources_types = set()
        for resource in self.dyn_resources:
            resources_types.add(resource.type.name)
            if resource.state != State.READY:
                sdk2.ResourceData(resource).ready()

        if not resources_types and not self.MUST_RELEASE:
            self.set_info('Warning: no resources for release')
            return

        description = 'Release of resources: {}'.format(', '.join(sorted(resources_types)))
        super(DynResourceMixin, self).on_release(dict(
            release_status=ReleaseStatus.STABLE,
            release_subject=description, release_comments=description,
            releaser=self.author
        ))

        if self.RESOURCE_COUNT is not None:
            for resource in self.dyn_resources:
                utils.set_resource_attributes(resource, {'deletable': True})

            for resource_type in resources_types:
                # оставляем RESOURCE_COUNT последних релизнутых ресурсов, остальные удаляем
                previous_resources = (
                    sdk2.Resource
                    .find(type=resource_type, state=State.READY, attrs={'released': ReleaseStatus.STABLE, 'deletable': True}, order='-id')
                    .offset(self.RESOURCE_COUNT).limit(10 ** 3)
                )
                for resource in previous_resources:
                    logging.debug('Delete resource %s', resource)
                    resource.ttl = 1  # delete
