# coding=utf-8
from sandbox.projects.resource_types import OTHER_RESOURCE

from sandbox import sdk2
from sandbox.projects.metrika.utils.mixins.console import BaseConsoleMixin


class BaseMavenMixin(BaseConsoleMixin):
    """
    Mixin для запуска maven. Задача должна декларировать необходимость Maven-окружения и Java-окружения
    """

    def _get_settings_xml_path(self):
        return sdk2.ResourceData(
            OTHER_RESOURCE.find(attrs=dict(maven="settings.xml"), state='READY').first()).path.as_posix()

    def _get_maven_cmd(self):
        return ['mvn', '--batch-mode', '--settings', self._get_settings_xml_path()]

    def _get_maven_local_repo_path(self):
        return self.path(".repository")

    def _create_props_args(self, props):
        base_props = {
            'maven.repo.local': self._get_maven_local_repo_path().as_posix(),
            'java.net.preferIPv6Addresses': 'true',
            'java.net.preferIPv4Stack': 'false'
        }

        base_props.update({k: v for k, v in props.iteritems() if v})

        return ['-D{}={}'.format(k, v) for k, v in base_props.iteritems()]

    def _execute_maven(self, targets, properties={}, cwd=None, env=None, timeout=None):
        """
        Запускает maven c settings.xml для Artifactory и локальным репозиторием.
        :param targets: цели сборки и параметры командной строки
        :param properties: словарь, элементы которого передаются как Java-properties через параметр командной строки -D
        :param cwd: каталог, в котором выполнить команду
        :param env: словарь с переменными среды
        :param timeout: таймаут на выполнение в секундах
        :return: ничего не возрващает, если код возврата не ноль, то будет выброшено исключение
        """
        cmd = self._get_maven_cmd() + self._create_props_args(properties) + targets

        self._execute_shell_and_check(cmd, cwd=cwd, env=env, timeout=timeout)
