# coding=utf-8
import sys


class Contextable(object):
    def __init__(self, storage=None):
        self.state = storage if storage is not None else {}

    def __get_caller_name(self):
        try:
            return sys._getframe(1).f_back.f_code.co_name
        except IndexError:
            return ""

    def _default_getter(self):
        return self.state.get(self.__get_caller_name(), None)

    def _default_setter(self, value):
        self.state[self.__get_caller_name()] = value

    def _default_fluent_setter(self, value):
        self.state[self.__get_caller_name().replace("with_", "")] = value
        return self
