CREATE TABLE IF NOT EXISTS sandbox_stat.sandbox_audit ON CLUSTER 'sandbox_stat_cluster'
(
    EventDate Date DEFAULT toDate(EventTime),
    EventTime DateTime,
    author String,
    owner String,
    task_id UInt64,
    task_type String,
    event Enum8
    (
      'CREATED'=0,
      'STARTED'=10,
      'STAGE_STARTED'=20,
      'STAGE_FINISHED'=30,
      'BROKEN'=50,
      'EXCEPTION'=60,
      'FAILURE'=70,
      'SUCCESS'=80
    ),
    params Array(String)
) ENGINE = ReplicatedMergeTree('/sandbox_audit', '{replica}',EventDate, (EventDate, task_type, event, author), 8192)
