CREATE TABLE IF NOT EXISTS sandbox_stat.sandbox_statistics ON CLUSTER 'sandbox_stat_cluster'
(
    EventDate Date DEFAULT toDate(StartTs),
    task_id UInt64,
    StageName String,
    StageTitle String,
    StartTs DateTime,
    FinishTs DateTime,
    RetryState Enum8
    (
      'FAIL'=10,
      'SUCCESS'=20
    )
) ENGINE = ReplicatedMergeTree('/sandbox_statistics', '{replica}',EventDate, (EventDate, task_id), 8192)
