PY23_LIBRARY()

OWNER(g:metrika-qa)

PY_SRCS(
    __init__.py
    common.py
    contextable.py
    pipeline.py
    pipeline_errors.py
    pipeline_state.py
    pipeline_view.py
    retry_memoize_creator.py
)

PEERDIR(
    contrib/python/six
    metrika/pylib/clickhouse
    sandbox/projects/common/decorators
    sandbox/projects/common/juggler
    sandbox/projects/metrika/utils
    sandbox/projects/metrika/utils/auth
    sandbox/projects/metrika/utils/base_metrika_task
    sandbox/projects/metrika/utils/settings
)

SET(SRC_ROOT "sandbox/projects/metrika/utils")

RESOURCE(
    view.html.jinja2 ${SRC_ROOT}/pipeline/view.html.jinja2
    ddl/audit/00-create-stat-table-repl.sql ${SRC_ROOT}/pipeline/ddl/audit/00-create-stat-table-repl.sql
    ddl/audit/01-alter-add-tags.sql ${SRC_ROOT}/pipeline/ddl/audit/01-alter-add-tags.sql
    ddl/audit/02-alter-add-abort-state.sql ${SRC_ROOT}/pipeline/ddl/audit/02-alter-add-abort-state.sql
    ddl/audit/03-alter-add-resume-event.sql ${SRC_ROOT}/pipeline/ddl/audit/03-alter-add-resume-event.sql
    ddl/statistics/00-create-table-repl.sql ${SRC_ROOT}/pipeline/ddl/statistics/00-create-table-repl.sql
)

END()
