import inspect
import logging
import sys

from sandbox.projects.metrika.utils import resource_types


class Mtapi(resource_types.BaseMetrikaBinaryResource):
    daemon_name = 'mtapi'


class MtapiClusterRefresher(resource_types.BaseMetrikaBinaryResource):
    daemon_name = 'mtapi-cluster-refresher'


class EventsTimingsd(resource_types.BaseMetrikaBinaryResource):
    daemon_name = 'events-timingsd-metrika-yandex'


def get_daemon_resource(daemon_name):
    for name, obj in inspect.getmembers(sys.modules[__name__], lambda x: inspect.isclass(x) and issubclass(x, resource_types.BaseMetrikaBinaryResource)):
        if obj.daemon_name == daemon_name:
            logging.debug("Use class %s for daemon_name %s" % (obj.name, daemon_name))
            break
    else:
        obj = resource_types.BaseMetrikaBinaryResource
        logging.warning("Can not find resource class for daemon_name %s, use default %s" % (daemon_name, obj.name))

    return obj
