import sandbox.projects.common.build.parameters as build_parameters


# Private YT-cache parameters, use only if you are know what are you doing in YaMake and YaPackage like tasks
# https://wiki.yandex-team.ru/users/konkov/sborochnyjj-kjesh-yt/proektnyjj-yt-kjesh/
# build type should be in heaters
PRIVATE_YT_STORE_PARAMS = {
    build_parameters.YtStoreParameters.ya_yt_store: True,
    build_parameters.YtStoreParameters.ya_yt_proxy: "hahn.yt.yandex.net",
    build_parameters.YtStoreParameters.ya_yt_dir: "//home/metrika-build/build-cache",
    build_parameters.YtStoreParameters.ya_yt_token_vault_owner: "METRIKA",
    build_parameters.YtStoreParameters.ya_yt_token_vault_name: "robot-metrika-admin-yt-token",
    build_parameters.YtStoreParameters.ya_yt_store_refresh_on_read: True
}


class PrivateYtStoreParameters(build_parameters.YtStoreParameters):
    ya_yt_store = build_parameters.YtStore(default_value=PRIVATE_YT_STORE_PARAMS[build_parameters.YtStoreParameters.ya_yt_store])
    ya_yt_proxy = build_parameters.YtProxy(default_value=PRIVATE_YT_STORE_PARAMS[build_parameters.YtStoreParameters.ya_yt_proxy])
    ya_yt_dir = build_parameters.YtDir(default_value=PRIVATE_YT_STORE_PARAMS[build_parameters.YtStoreParameters.ya_yt_dir])
    ya_yt_token_vault_owner = build_parameters.YtTokenVaultOwner(default_value=PRIVATE_YT_STORE_PARAMS[build_parameters.YtStoreParameters.ya_yt_token_vault_owner])
    ya_yt_token_vault_name = build_parameters.YtTokenVaultName(default_value=PRIVATE_YT_STORE_PARAMS[build_parameters.YtStoreParameters.ya_yt_token_vault_name])
    ya_yt_store_refresh_on_read = build_parameters.YtStoreRefreshOnRead(default_value=PRIVATE_YT_STORE_PARAMS[build_parameters.YtStoreParameters.ya_yt_store_refresh_on_read])
