import sandbox.projects.common.build.parameters as build_parameters
from sandbox import sdk2
from sandbox.projects.common import binary_task
from sandbox.projects.common.binary_task import LastRefreshableBinary
from sandbox.projects.common.build.KosherYaMake import KosherYaMake
from sandbox.projects.metrika.utils.requirements import MetrikaLargeRequirements


# Don't use @with_parents bc code in KosherYaMake and its parents may call some on_ methods explicitly
# Inherit with caution
class MetrikaYaMake(KosherYaMake, LastRefreshableBinary):
    class Requirements(MetrikaLargeRequirements):
        pass

    class Parameters(KosherYaMake.Parameters):
        use_arc_instead_of_aapi = build_parameters.UseArcInsteadOfArcadiaApi(default_value=True)
        sandbox_tags = sdk2.parameters.String('Sandbox task tags. Doc: https://nda.ya.ru/3RhRAc', default='')

        _binary = binary_task.binary_release_parameters_list(stable=True)

    def on_enqueue(self):
        LastRefreshableBinary.on_enqueue(self)
        KosherYaMake.on_enqueue(self)

    def on_wait(self, prev_status, status):
        LastRefreshableBinary.on_wait(self, prev_status, status)
        KosherYaMake.on_wait(self, prev_status, status)
