# coding=utf-8
import os
import shutil

from sandbox.common.errors import TaskError
from sandbox.projects.common.arcadia.sdk import mount_arc_path
from sandbox.sdk2.vcs.svn import Arcadia


def mount_arc(url):
    os.environ["ARC_SKIP_SERVER_CACHE"] = "true"
    return mount_arc_path(url, fetch_all=False)


def checkout(vcs_block, work_dir):
    if vcs_block.vcs == 'arcadia':
        with mount_arc(vcs_block.arcadia_url) as arcadia:
            checkout_arcadia(vcs_block, arcadia, work_dir)

        return work_dir
    else:
        raise TaskError('Unsupported VCS {}'.format(vcs_block.vcs))


def checkout_arcadia(vcs_block, arcadia, work_dir):
    if vcs_block.arcadia_patch:
        arcadia_patch_path, is_zip = Arcadia.fetch_patch(vcs_block.arcadia_patch, arcadia)
        Arcadia.apply_patch_file(arcadia, arcadia_patch_path, is_zip)

    shutil.copytree(str(os.path.join(arcadia, vcs_block.arcadia_path)), work_dir)
