from sandbox import sdk2


MIRRORS_RELEASERS = ['JUPITER']


class MirrorsResourceBase(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = MIRRORS_RELEASERS
    ttl = 100


class MirrorsBaseBinaries(MirrorsResourceBase):
    """
    Contains binaries used in mirrors base generation
    """
    pass


class MirrorsMergeBinaries(MirrorsResourceBase):
    """
    Contains binaries used in mirrors merge subgraph
    """
    pass


class MirrorsToolsBinaries(MirrorsResourceBase):
    """
    Contains tools binaries used in mirrors
    """
    pass


class MirrorsHypsBinaries(MirrorsResourceBase):
    """
    Contains hyps binaries used in mirrors
    """
    pass


class MirrorsFetchBinaries(MirrorsResourceBase):
    """
    Contains fetcher/scheduler binary
    """
    pass


class MirrorsFetcher(MirrorsResourceBase):
    """
    Contains fetcher binary
    """
    pass


class MirrorsScheduler(MirrorsResourceBase):
    """
    Contains scheduler binary
    """
    pass


class MirrorsViewerBinaries(MirrorsResourceBase):
    """
    Contains binaries for mirrors viewer
    """
    pass


class MirrorsWrapperBinaries(MirrorsResourceBase):
    """
    Contains binaries for mirrors checker proxy
    """
    pass


class MirrorsCmpy(MirrorsResourceBase):
    """
    Contains binary for mirrors cm
    """
    pass


class MirrorsConfigs(MirrorsResourceBase):
    """
    Contains mirrors configs
    """
    pass


class MirrorsCmConfigs(MirrorsResourceBase):
    """
    Contains mirrors cm configs
    """
    pass


class MirrorsDbConfigs(MirrorsResourceBase):
    """
    Contains mirrors db configs
    """
    pass


class MirrorsFetcherConfigs(MirrorsResourceBase):
    """
    Contains mirrors fetcher configs
    """
    pass


class MirrorsRthubConfigs(MirrorsResourceBase):
    """
    Contains mirrors rthub configs
    """
    pass


class MirrorsSchedulerConfigs(MirrorsResourceBase):
    """
    Contains mirrors scheduler configs
    """
    pass


class MirrorsViewerConfigs(MirrorsResourceBase):
    """
    Contains mirrors viewer configs
    """
    pass


class MirrorsWrapperConfigs(MirrorsResourceBase):
    """
    Contains mirrors wrapper configs
    """
    pass


class PublicDomainSuffixes(MirrorsResourceBase):
    """
    Contains list of public domain suffixes (tld)
    """
    pass
