from sandbox import sdk2


class MinusResourceBase(sdk2.Resource):
    releasers = [
        'levobuhov',
        'vvp',
        'avatar'
        'dskor',
        'robot-ivy-poison',
        'MINUS'
    ]


class MinusBundle(MinusResourceBase):
    """
       Bundle for minus deployment
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class MinusTestingBundle(MinusResourceBase):
    """
       Bundle for minus deployment
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class MinusNginxPackage(MinusResourceBase):
    """
        Nginx as package for minus
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class MinusBinaryPackage(MinusResourceBase):
    """
        minus binary as package
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class MinusConfigsPackage(MinusResourceBase):
    """
        Configs and resources for minus (production)
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class MinusTestingConfigsPackage(MinusResourceBase):
    """
        Configs and resources for minus (testing)
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True
