from sandbox import sdk2


class SaturnResourceBase(sdk2.Resource):
    releasers = [
        'levobuhov',
        'vvp',
        'avatar',
        'robot-ivy-poison',
        'SATURN'
    ]


class SaturnBundle(SaturnResourceBase):
    """
       Bundle for saturn deployment
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class SaturnTestingBundle(SaturnResourceBase):
    """
       Bundle for saturn deployment
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class SaturnNginxPackage(SaturnResourceBase):
    """
        Nginx as package for saturn
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class SaturnBinaryPackage(SaturnResourceBase):
    """
        saturn binary as package
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class SaturnConfigsPackage(SaturnResourceBase):
    """
        Configs and resources for saturn (production)
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class SaturnTestingConfigsPackage(SaturnResourceBase):
    """
        Configs and resources for saturn (testing)
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True
