from sandbox import sdk2

from sandbox.projects.tank.load_resources import resources as tank_resources
from sandbox.projects.tank import executor2 as tank_executor

import os

RPS_KEY = "shooting.rps_0.5"


class SmartSubjectComparePerfTests(sdk2.Task):
    """ Task for comparing Smart Subject performance """

    class Parameters(sdk2.Task.Parameters):
        task1_resource = sdk2.parameters.Resource(
            "Resource Recommender performance stats",
            resource_type=tank_resources.YANDEX_TANK_LOGS,
            required=True
        )
        task2_resource = sdk2.parameters.Resource(
            "Resource Recommender performance stats",
            resource_type=tank_resources.YANDEX_TANK_LOGS,
            required=True
        )
        max_delta = sdk2.parameters.Integer("Max delta between rps in percents", default=7, required=True)

    def on_execute(self):
        task1_resource_data = sdk2.ResourceData(self.Parameters.task1_resource)
        task2_resource_data = sdk2.ResourceData(self.Parameters.task2_resource)

        task1_stats = self.load_stats(str(task1_resource_data.path))
        task2_stats = self.load_stats(str(task2_resource_data.path))

        self.Context.task1_rps = task1_stats[RPS_KEY]
        self.Context.task2_rps = task2_stats[RPS_KEY]
        self.Context.delta = abs(self.Context.task2_rps - self.Context.task1_rps)

        self.Context.has_diff = self.Context.delta > self.Context.task1_rps * self.Parameters.max_delta / 100

    def load_stats(self, logs_path):
        return tank_executor.DolbiloPlugin.get_stats(os.path.join(logs_path, "artifacts"))

    @sdk2.header()
    def header(self):
        if self.Context.has_diff:
            return 'Significant diff: %s rps -> %s rps' % (self.Context.task1_rps, self.Context.task2_rps)
        return 'Insignificant diff: %s rps -> %s rps' % (self.Context.task1_rps, self.Context.task2_rps)
