from sandbox.projects import resource_types

from sandbox import sdk2

from sandbox.projects.mlp.smartsubject.components import SmartSubjectRecommender
from sandbox.projects.mlp.smartsubject.resources import MailSsBundle

from sandbox.projects.collections.recommender_base.shooting_task2 import ShootingTask2

from sandbox.projects.common import dolbilka2
from sandbox.projects.tank import executor2 as tank_executor

import os
import json


class SmartSubjectPerfTest(sdk2.Task, ShootingTask2):
    """ Task for testing base Smart Subject performance """

    class Parameters(sdk2.Task.Parameters):
        recommender_http_port = sdk2.parameters.Integer("Http Port for Ind Service", default=15358, required=True)
        request_count = sdk2.parameters.Integer("Count of requests", default=100000, required=True)

        bundle_resource = sdk2.parameters.Resource(
            "Resource with Ind bundle",
            resource_type=MailSsBundle,
            required=True
        )
        dolbilka_plan_resource = sdk2.parameters.Resource(
            "Resource with dolbilka plan",
            resource_type=resource_types.BASESEARCH_PLAN,
            required=True
        )

        dolbilka_param = dolbilka2.DolbilkaExecutor2.Parameters
        lunapark_param = tank_executor.LunaparkPlugin.Parameters
        offline_param = tank_executor.OfflinePlugin.Parameters

        env_json = sdk2.parameters.String("JSON to set ENV", default="{}", required=True)

    class Requirements(sdk2.Task.Requirements):
        ram = 80 * 1024
        disk_space = 100 * 1024
        client_tags = ShootingTask2.client_tags
        cores = 4

    def on_execute(self):
        os.environ.update(json.loads(self.Parameters.env_json))
        bundle_resource_data = sdk2.ResourceData(self.Parameters.bundle_resource)

        recommender = SmartSubjectRecommender(self,
                                              str(bundle_resource_data.path),
                                              self.Parameters.recommender_http_port)

        self._init_virtualenv()
        self._dolbilo_shoot(self.Parameters.recommender_http_port, self.Parameters.dolbilka_plan_resource, "perf_test")

        recommender.close()

    @sdk2.footer()
    def footer(self):
        return ShootingTask2.footer(self)
