from sandbox import sdk2
from sandbox.sandboxsdk.network import is_port_free

from sandbox.sdk2.helpers import subprocess as sp

import tarfile
import time


class SmartSubjectRecommender:
    def __init__(self, task, bundle_path, port):
        with tarfile.open(bundle_path, "r:gz") as tar:
            tar.extractall()

        self.process_log = sdk2.helpers.ProcessLog(task, logger="smart_subject.log")
        self.process = sp.Popen(
            [
                "./http",
                "-b", "data",
                "-s", "configs/server_sandbox_config.pbtxt",
                "-c", "configs/chains_config.pbtxt",
                "--port", str(port),
            ],
            stdout=self.process_log.stdout, stderr=sp.STDOUT,
        )

        while is_port_free(port):
            time.sleep(1)
            if self.process.poll() is not None:
                raise RuntimeError("Error in Smart Subject server starting")

    def raise_if_error_in_logs(self):
        tokens = [  # filter log by it
            "worker started",
            "mock authorization",
            "tvm client not inititialized"
        ]
        with open(str(self.process_log.stdout.path), 'r') as f:
            text = f.read()
        if any(line and all(token not in line for token in tokens) for line in text.split('\n')):
            raise Exception("Something bad in logs. Check it. smart_subject.log.out.log")

    def close(self):
        self.raise_if_error_in_logs()
        self.process.terminate()
