from sandbox import sdk2


DISTRICTS_RELEASERS = [
    'lyubanenko',
    'robot-mlp-district'
]


class DISTRICTS_PROFILE_TRIE_TEST(sdk2.Resource):
    """
        latest testing district post profiles packed in trie
    """
    executable = False
    releasable = True
    auto_backup = False
    any_arch = True
    releasers = DISTRICTS_RELEASERS


class DISTRICTS_PROFILE_TRIE_PROD(sdk2.Resource):
    """
        latest production district post profiles packed in trie
    """
    executable = False
    releasable = True
    auto_backup = False
    any_arch = True
    releasers = DISTRICTS_RELEASERS


class DISTRICTS_PROFILE_SHARD_TEST(sdk2.Resource):
    """
        latest testing district post profiles packed in shard
    """
    executable = False
    releasable = True
    auto_backup = False
    any_arch = True
    releasers = DISTRICTS_RELEASERS


class DISTRICTS_PROFILE_SHARD_PROD(sdk2.Resource):
    """
        latest production district post profiles packed in shard
    """
    executable = False
    releasable = True
    auto_backup = False
    any_arch = True
    releasers = DISTRICTS_RELEASERS


class DISTRICTS_MODEL_PACK_TEST(sdk2.Resource):
    """
        latest testing district catboost models
    """
    executable = False
    releasable = True
    auto_backup = False
    any_arch = True
    releasers = DISTRICTS_RELEASERS


class DISTRICTS_MODEL_PACK_PROD(sdk2.Resource):
    """
        latest production district catboost models
    """
    executable = False
    releasable = True
    auto_backup = False
    any_arch = True
    releasers = DISTRICTS_RELEASERS


class DISTRICTS_TRAGIC_EXPORT(sdk2.Resource):
    """
        tragic posts export for assessors
    """
    auto_backup = False
    share = False


GAMES_RELEASERS = [
    'adota',
    'lyubanenko',
    'robot-mlp-games'
]


class GAMES_PROFILE_SHARD_TEST(sdk2.Resource):
    """
        latest testing games shard
    """
    executable = False
    releasable = True
    auto_backup = False
    any_arch = True
    releasers = GAMES_RELEASERS


class GAMES_PROFILE_SHARD_PROD(sdk2.Resource):
    """
        latest production games shard
    """
    executable = False
    releasable = True
    auto_backup = False
    any_arch = True
    releasers = GAMES_RELEASERS


MSSNGR_RELEASERS = [
    'lyubanenko',
    'pagein',
    'robot-mlp-mssngr'
]


class MSSNGR_PROFILE_SHARD_TEST(sdk2.Resource):
    """
        latest testing messenger shard
    """
    executable = False
    releasable = True
    auto_backup = False
    any_arch = True
    releasers = MSSNGR_RELEASERS


class MSSNGR_PROFILE_SHARD_PROD(sdk2.Resource):
    """
        latest production messenger shard
    """
    executable = False
    releasable = True
    auto_backup = False
    any_arch = True
    releasers = MSSNGR_RELEASERS


class MSSNGR_RECOMMENDER_SERVER_PACK(sdk2.Resource):
    """
    Recommender server package
    """
    executable = False
    releasable = True
    auto_backup = False
    any_arch = False
    releasers = MSSNGR_RELEASERS


class MSSNGR_CFSHARP_MODEL_SHARD(sdk2.Resource):
    """
    Shard with CF# model serialized as profiles
    """
    executable = False
    releasable = True
    auto_backup = False
    any_arch = False
    releasers = MSSNGR_RELEASERS
