#!/usr/bin/env bash -xe
set -e
TICKET=$1
RUNNER_VERSION=$2
if [ -z $RUNNER_VERSION ]
then
  echo "RUNNER_VERSION is empty"
  exit 1
fi

for PROJECT_DIR in `find . -maxdepth 1 -mindepth 1 -type d | xargs -n1 | egrep -v common`;

do
  CUR_DIR=`pwd`
  PROJECT=`echo $PROJECT_DIR | sed -e s/\\\.\\\///g`
  echo "Try to update $PROJECT"
  cd $PROJECT_DIR
  arc checkout trunk
  arc pull trunk
  pwd
  TSR_CURRENT_VERSIONS=`ya grep -A1 runner_version -d=. | egrep -v 'runner_version' | awk '{print $2}' | sort | uniq`

  for i in $TSR_CURRENT_VERSIONS;
  do
    ya sed local --file-regexp '.yaml' "$i" "$RUNNER_VERSION";
  done

  SHOULD_COMMIT=`arc st 2>&1 | grep 'nothing to commit, working directory clean' > /dev/null; echo $?`
  if [ $SHOULD_COMMIT -ne "1" ]; then
    echo "Nothing to commit for ${PROJECT}. Move along"
  else
    arc checkout -b "${TICKET}_${PROJECT}_${RUNNER_VERSION}"
    arc add .
    arc commit -m "Update runner_version to $RUNNER_VERSION"
    arc st
    arc pr create --push -m "$PROJECT: TSR up to $RUNNER_VERSION" # --publish
  fi
  cd $CUR_DIR
  # read -n1 -r -p "Press any key to continue..." key;
done
