import re
import time
import datetime
import logging


BASE_HTML = '''
<script type=\"text/javascript\">

function openbox(id){
    display = document.getElementById(id).style.display;
    if(display==\'none\'){
       document.getElementById(id).style.display=\'block\';
    }else{
       document.getElementById(id).style.display=\'none\';
    }
}
</script>

<style>
    DIV {
        font-family: Arial;
    }

    DIV.clickable {
        width: 97%;
        height:18pt;
        background:#EBEDEF no-repeat 5px 5px;.
        border-bottom: 1px solid #E3E9EF;
        cursor: pointer;
        margin: auto;
        font-size: 14pt;
        font-weight: 600;
        padding-left: 10pt;
    }
    DIV.appearing {
        font-size: 12pt;
        margin: auto;
        width: 90%;
        font-weight: 300;
        padding: 10pt;
    }
    DIV.skipped_info {
        font-size: 16pt;
        margin: auto;
        width: 90%;
        padding: 10pt;
    }
</style>
'''
CLICKABLE_HTML = '''
<div class=\"clickable\" onclick=\"openbox(\'{}\'); return false\"><font face=\"wingdings\" color={}> &#9642;</font>{} TIME_INFO</div>
'''
TIME_INFO = 'TIME_INFO'
APPEARING_HTML = '''
<div class=\"appearing\" id=\"{}\" style=\"display: none; color: {};\"><pre><code>{}</code></pre></div>
'''
CODE_STRING = '<font color={}>{}</font>\n'
GREEN = 'green'
RED = 'red'
YELLOW = 'e5be01'
BLACK = 'black'
TOO_LONG_LOG = '<font color=black>This log is too large therefore was skipped.</font>\n'
SKIPPED_LOG_INFO = '<div class=\"skipped_info\">All large logs were skipped, see the full report in artifacts/full_index.html</div>'


class HtmlLogReporter(object):
    def __init__(self):
        self._html = BASE_HTML
        self._short_html = BASE_HTML + SKIPPED_LOG_INFO
        self._text_log = ''
        self._teamcity_messages = ''

    def _extract_time(self, str_time):
        logging.info(str_time)
        pattern = r'\d{4,4}-\d{2,2}-\d{2,2} \d{2,2}:\d{2,2}:\d{2,2}'
        logging.info(re.findall(pattern, str_time))
        log_date_str = re.findall(pattern, str_time)[0]
        log_date = datetime.datetime.strptime(log_date_str, "%Y-%m-%d %H:%M:%S")
        return time.mktime(log_date.timetuple()) + (log_date.microsecond / 1000000.0)

    def _scan_for_teamcity_messages(self, text):
        for line in text.split('\n'):
            pos = line.find('##teamcity')
            if pos >= 0 and line.endswith(']'):
                self._teamcity_messages = '{}\n{}'.format(self._teamcity_messages, line[pos:])

    def _append_log_div(self, html_log, name, status, key_words, div_name, add_to_text_log, color):
        total_time_info = ''
        if add_to_text_log:
            try:
                text_log = 'STAGE:{} TIME_INFO\n{}'.format(name, html_log)
                first_log_time = self._extract_time(html_log[:html_log.find('\n')])
                last_log_time = self._extract_time(html_log[html_log.rfind('\n') + 1:])
                total_time = time.strftime('%Hh:%Mm:%Ss', time.gmtime(last_log_time - first_log_time))
                total_time_info = 'TOTAL: {}'.format(total_time)
                teamcity_statistics = '##teamcity[buildStatisticValue key=\'{}\' value=\'{}\']'.format(div_name, (last_log_time - first_log_time)*1000)
                self._text_log = '{}\n\n{}'.format(self._text_log, teamcity_statistics)
                self._teamcity_messages = '{}\n{}'.format(self._teamcity_messages, teamcity_statistics)
            except Exception as e:
                logging.exception(e)
            self._scan_for_teamcity_messages(html_log)
        if html_log != '':
            if add_to_text_log:
                self._text_log = '{}\n\n{}'.format(self._text_log, text_log.replace(TIME_INFO, total_time_info))
        full_log = CLICKABLE_HTML.format(div_name, self._status_color, div_name).replace(TIME_INFO, total_time_info) + APPEARING_HTML.format(div_name, color, html_log)
        short_log = CLICKABLE_HTML.format(div_name, self._status_color, div_name).replace(TIME_INFO, total_time_info) + APPEARING_HTML.format(div_name, BLACK, TOO_LONG_LOG)
        if len(full_log) >= 5 << 20:
            self._short_html += short_log
        else:
            self._short_html += full_log
        self._html += full_log

    def append_stage_log(self, info_stage_log, err_stage_log, stage_name, stage_status):
        logging.info('Started appending stage log')
        err_stage_log = '\n('.join(err_stage_log.split('\n(')[::2])
        if stage_status:
            self._status_color = RED
            self._stderr_color = RED
        else:
            self._status_color = GREEN
            self._stderr_color = YELLOW
        self._append_log_div(info_stage_log, stage_name, stage_status, ['INFO', 'ERROR'], stage_name + ' (stdout + stderr)', True, BLACK)
        logging.info('INFO+ERROR added')
        self._append_log_div(err_stage_log, stage_name, stage_status, ['ERROR'], stage_name + ' (stderr)', False, self._stderr_color)
        logging.info('ERROR added')

    @property
    def html(self):
        return self._html

    @property
    def short_html(self):
        return self._short_html

    @property
    def text_log(self):
        return self._text_log

    @property
    def teamcity_messages(self):
        return self._teamcity_messages
