import sandbox.common.types.task as ctt
import sandbox.common.types.notification as ctn

from sandbox import sdk2


class TeamcitySandboxRunnerVersionParameters(sdk2.Task.Parameters):
    notifications = [
        sdk2.Notification(
            [ctt.Status.EXCEPTION, ctt.Status.TIMEOUT],
            ['mobdevtools-dev@yandex-team.ru'],
            ctn.Transport.EMAIL
        )
    ]
    with sdk2.parameters.Group('Teamcity sandbox runner version parameters') as tsr_version_params:
        with sdk2.parameters.RadioGroup('Binary release type') as release_type:
            release_type.values.stable = release_type.Value(value='stable', default=True)
            release_type.values.test = release_type.Value(value='test')
            release_type.values.none = release_type.Value(value='none')
            release_type.values.custom = release_type.Value(value='custom')
        version = sdk2.parameters.String(
            'Version',
            required=False,
            default='', )


class TeamcitySandboxRunnerCommonParameters(TeamcitySandboxRunnerVersionParameters):
    with sdk2.parameters.Group('Teamcity sandbox runner vcs parameters') as tsr_common_params:
        repo_url = sdk2.parameters.String(
            'Repo URL',
            default='arcadia', )
        branch = sdk2.parameters.String(
            'Branch',
            default='arcadia/trunk', )
        commit = sdk2.parameters.String(
            'Commit', )
        ssh_key = sdk2.parameters.Vault(
            'SSH key', )
    with sdk2.parameters.Group('Teamcity parameters') as teamcity_params:
        teamcity_build_id = sdk2.parameters.Integer(
            'TeamCity build ID',
            description='ID of TeamCity build triggered this task.',
            required=False,
            default=None
        )
    with sdk2.parameters.Group('Service parameters') as service_params:
        force_clean_build = sdk2.parameters.Bool(
            'Force clean build',
            description='if True, cache archives will be reassembled',
            default=False
        )
        mac_agent = sdk2.parameters.String(
            'mac agent hostname',
            default='',
        )
        linux_agent = sdk2.parameters.String(
            'linux agent hostname',
            default='',
        )
    with sdk2.parameters.Group('Override Teamcity sandbox runner vcs parameters') as tsr_config_location:
        custom_config_repo_url = sdk2.parameters.String(
            'Repo URL',
            default='', )
        custom_config_branch = sdk2.parameters.String(
            'Branch',
            default='', )
        custom_config_commit = sdk2.parameters.String(
            'Commit', default='')


class TeamcitySandboxRunnerUpperLevelParameters(TeamcitySandboxRunnerCommonParameters):
    with sdk2.parameters.Group('Teamcity sandbox runner config parameters') as tsr_config_params:
        config_from_repository = sdk2.parameters.Bool(
            'Take config from repository',
            default=True, )
        with config_from_repository.value[False]:
            config = sdk2.parameters.String(
                'Config (yaml)',
                multiline=True, )
        with config_from_repository.value[True]:
            config_path = sdk2.parameters.String(
                'Config path', )
    repo_url = sdk2.parameters.String(
        'Repo URL',
        default='ssh://git@bb.yandex-team.ru/mobile/monorepo.git', )
    branch = sdk2.parameters.String(
        'Branch',
        default='refs/master', )
    commit = sdk2.parameters.String(
        'Commit', )
    env = sdk2.parameters.String(
        'env',
        default='{}', )
    secrets = sdk2.parameters.String(
        'secrets',
        default='{}', )


class TeamcitySandboxRunnerArtifactsParameters(sdk2.Task.Parameters):
    with sdk2.parameters.Group('Teamcity sandbox runner artifacts parameters') as tsr_artifacts_params:
        use_parent_resources = sdk2.parameters.Bool(
            'Use resources from parent task',
            default=False, )
        with use_parent_resources.value[True]:
            teamcity_artifacts_resource = sdk2.parameters.ParentResource(
                'Teamcity artifacts resource', )
            teamcity_messages_resource = sdk2.parameters.ParentResource(
                'Teamcity messages resource', )
